/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.i2c.impl;

import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CFactory;
import com.pi4j.io.i2c.I2CFactoryProvider;
import com.pi4j.io.i2c.impl.I2CBusImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class I2CProviderImpl
implements I2CFactoryProvider {
    private static final Map<Integer, I2CBus> busSingletons = new HashMap<Integer, I2CBus>();
    private static final Lock singletonPerBusLock = new ReentrantLock(true);

    protected static I2CBus getBus(int busNumber, Callable<I2CBusImpl> constructor, long lockAquireTimeout, TimeUnit lockAquireTimeoutUnit) throws I2CFactory.UnsupportedBusNumberException, IOException {
        InterruptedException lockException;
        block8: {
            lockException = null;
            try {
                I2CBus bus;
                if (!singletonPerBusLock.tryLock(lockAquireTimeout, lockAquireTimeoutUnit)) break block8;
                try {
                    bus = busSingletons.get(busNumber);
                    if (bus == null) {
                        I2CBusImpl newInstanceCandidate = constructor.call();
                        newInstanceCandidate.open();
                        bus = newInstanceCandidate;
                        busSingletons.put(newInstanceCandidate.busNumber, bus);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not instantiate I2CBus", e);
                }
                finally {
                    singletonPerBusLock.unlock();
                }
                return bus;
            }
            catch (InterruptedException e) {
                lockException = e;
            }
        }
        throw new RuntimeException("Could not abtain lock to build new bus!", lockException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void closeBus(int busNumber, long lockAquireTimeout, TimeUnit lockAquireTimeoutUnit, Callable<Void> closeAction) {
        InterruptedException lockException;
        block12: {
            lockException = null;
            try {
                if (!singletonPerBusLock.tryLock(lockAquireTimeout, lockAquireTimeoutUnit)) break block12;
                try {
                    closeAction.call();
                    return;
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot close bus", e);
                }
                finally {
                    try {
                        busSingletons.remove(busNumber);
                    }
                    finally {
                        singletonPerBusLock.unlock();
                    }
                }
            }
            catch (InterruptedException e) {
                lockException = e;
            }
        }
        throw new RuntimeException("Could not abtain lock to close the bus!", lockException);
    }

    @Override
    public I2CBus getBus(final int busNumber, final long lockAquireTimeout, final TimeUnit lockAquireTimeoutUnit) throws I2CFactory.UnsupportedBusNumberException, IOException {
        return I2CProviderImpl.getBus(busNumber, new Callable<I2CBusImpl>(){

            @Override
            public I2CBusImpl call() throws I2CFactory.UnsupportedBusNumberException {
                return new I2CBusImpl(busNumber, I2CProviderImpl.this.getFilenameForBusnumber(busNumber), lockAquireTimeout, lockAquireTimeoutUnit);
            }
        }, lockAquireTimeout, lockAquireTimeoutUnit);
    }

    protected abstract String getFilenameForBusnumber(int var1) throws I2CFactory.UnsupportedBusNumberException;
}

