/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.i2c.impl;

import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.I2CFactory;
import com.pi4j.io.i2c.impl.I2CDeviceImpl;
import com.pi4j.io.i2c.impl.I2CProviderImpl;
import com.pi4j.jni.I2C;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class I2CBusImpl
implements I2CBus {
    private static final Logger logger = Logger.getLogger(I2CBusImpl.class.getCanonicalName());
    protected int fd = -1;
    protected String filename;
    protected int busNumber;
    protected long lockAquireTimeout;
    protected TimeUnit lockAquireTimeoutUnit;
    private final ReentrantLock accessLock = new ReentrantLock(true);

    protected I2CBusImpl(int busNumber, String fileName, long lockAquireTimeout, TimeUnit lockAquireTimeoutUnit) {
        this.filename = fileName;
        this.busNumber = busNumber;
        this.lockAquireTimeout = lockAquireTimeout < 0L ? 1000L : lockAquireTimeout;
        this.lockAquireTimeoutUnit = lockAquireTimeoutUnit == null ? I2CFactory.DEFAULT_LOCKAQUIRE_TIMEOUT_UNITS : lockAquireTimeoutUnit;
    }

    @Override
    public I2CDevice getDevice(int address) throws IOException {
        return new I2CDeviceImpl(this, address);
    }

    protected void open() throws IOException {
        if (this.fd != -1) {
            return;
        }
        this.fd = I2C.i2cOpen(this.filename);
        if (this.fd < 0) {
            throw new IOException("Cannot open file handle for " + this.filename + " got " + this.fd + " back.");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fd == -1) {
            return;
        }
        I2CProviderImpl.closeBus(this.getBusNumber(), this.lockAquireTimeout, this.lockAquireTimeoutUnit, new Callable<Void>(){

            @Override
            public Void call() {
                I2C.i2cClose(I2CBusImpl.this.fd);
                I2CBusImpl.this.fd = -1;
                return null;
            }
        });
    }

    public int readByteDirect(final I2CDeviceImpl device) throws IOException {
        this.testForProperOperationConditions(device);
        return this.runActionOnExclusivLockedBus(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return I2C.i2cReadByteDirect(I2CBusImpl.this.fd, device.getAddress());
            }
        });
    }

    public int readBytesDirect(final I2CDeviceImpl device, final int size, final int offset, final byte[] buffer) throws IOException {
        this.testForProperOperationConditions(device);
        return this.runActionOnExclusivLockedBus(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return I2C.i2cReadBytesDirect(I2CBusImpl.this.fd, device.getAddress(), size, offset, buffer);
            }
        });
    }

    public int readByte(final I2CDeviceImpl device, final int localAddress) throws IOException {
        this.testForProperOperationConditions(device);
        return this.runActionOnExclusivLockedBus(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return I2C.i2cReadByte(I2CBusImpl.this.fd, device.getAddress(), localAddress);
            }
        });
    }

    public int readBytes(final I2CDeviceImpl device, final int localAddress, final int size, final int offset, final byte[] buffer) throws IOException {
        this.testForProperOperationConditions(device);
        return this.runActionOnExclusivLockedBus(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return I2C.i2cReadBytes(I2CBusImpl.this.fd, device.getAddress(), localAddress, size, offset, buffer);
            }
        });
    }

    public int writeByteDirect(final I2CDeviceImpl device, final byte data) throws IOException {
        this.testForProperOperationConditions(device);
        return this.runActionOnExclusivLockedBus(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return I2C.i2cWriteByteDirect(I2CBusImpl.this.fd, device.getAddress(), data);
            }
        });
    }

    public int writeBytesDirect(final I2CDeviceImpl device, final int size, final int offset, final byte[] buffer) throws IOException {
        this.testForProperOperationConditions(device);
        return this.runActionOnExclusivLockedBus(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return I2C.i2cWriteBytesDirect(I2CBusImpl.this.fd, device.getAddress(), size, offset, buffer);
            }
        });
    }

    public int writeByte(final I2CDeviceImpl device, final int localAddress, final byte data) throws IOException {
        this.testForProperOperationConditions(device);
        return this.runActionOnExclusivLockedBus(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return I2C.i2cWriteByte(I2CBusImpl.this.fd, device.getAddress(), localAddress, data);
            }
        });
    }

    public int writeBytes(final I2CDeviceImpl device, final int localAddress, final int size, final int offset, final byte[] buffer) throws IOException {
        this.testForProperOperationConditions(device);
        return this.runActionOnExclusivLockedBus(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return I2C.i2cWriteBytes(I2CBusImpl.this.fd, device.getAddress(), localAddress, size, offset, buffer);
            }
        });
    }

    public int writeAndReadBytesDirect(final I2CDeviceImpl device, final int writeSize, final int writeOffset, final byte[] writeBuffer, final int readSize, final int readOffset, final byte[] readBuffer) throws IOException {
        this.testForProperOperationConditions(device);
        return this.runActionOnExclusivLockedBus(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return I2C.i2cWriteAndReadBytes(I2CBusImpl.this.fd, device.getAddress(), writeSize, writeOffset, writeBuffer, readSize, readOffset, readBuffer);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T runActionOnExclusivLockedBus(Callable<T> action) throws IOException {
        if (action == null) {
            throw new RuntimeException("Parameter 'action' is mandatory!");
        }
        this.testWhetherBusHasAlreadyBeenClosed();
        try {
            if (!this.accessLock.tryLock(this.lockAquireTimeout, this.lockAquireTimeoutUnit)) throw new RuntimeException("Could not abtain an access-lock!");
            try {
                T t = action.call();
                return t;
            }
            finally {
                this.accessLock.unlock();
            }
        }
        catch (InterruptedException e) {
            logger.log(Level.FINER, "Failed locking I2CBusImpl-" + this.busNumber, e);
            throw new RuntimeException("Could not abtain an access-lock!", e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void testForProperOperationConditions(I2CDeviceImpl device) throws IOException {
        this.testWhetherBusHasAlreadyBeenClosed();
        if (device == null) {
            throw new NullPointerException("Parameter 'device' is mandatory!");
        }
    }

    private void testWhetherBusHasAlreadyBeenClosed() throws IOException {
        if (this.fd == -1) {
            throw new IOException(this.toString() + " has already been closed! A new bus has to be aquired.");
        }
    }

    @Override
    public int getBusNumber() {
        return this.busNumber;
    }

    public String toString() {
        return "I2CBus '" + this.busNumber + "' ('" + this.filename + "')";
    }
}

